#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators
{
	public class BMDRotationDecisionCandle : Indicator
	{
		
	
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"BMDRotationDecisionCandle";
				Name										= "BMDRotationDecisionCandle";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				
				MaintainPercentageOfOwnVolume = .50;
				TakeOutPercentageOfPreviousBarsVolume = .50;	
				DoesntTradeMoreThanPercentageFromOpen = .20;
				BarMustBeAtLeastThisPercentageOfATR = .85;
				BullishOutlineColor = Brushes.LimeGreen;
				BullishCandleColor = Brushes.Black;
				BearishOutlineColor = Brushes.OrangeRed;
				BearishCandleColor = Brushes.DarkRed;
			}
		
		}

		protected override void OnBarUpdate()
		{
			if( CurrentBar < 3 )return;
			
			double range = High[0] - Low[0];
			double prevRange = High[1] - Low[1];
			
			if(range < (ATR(20)[0] * BarMustBeAtLeastThisPercentageOfATR)){
				return;
			}
			
											
			if((range * MaintainPercentageOfOwnVolume) < (Close[0] - Low[0])) { // maintain 50% of own volume				
				if(Close[0] > Low[1] + (prevRange * TakeOutPercentageOfPreviousBarsVolume)){ // takes out 50% of previous bars range
					if((Open[0] - Low[0]) < range * DoesntTradeMoreThanPercentageFromOpen){ // doesn't trade more than 20% of own range lower than open
						BarBrushes[0] = BullishCandleColor;
						CandleOutlineBrushes[0] = BullishOutlineColor;
					}
				}
			}
		
			if((range * MaintainPercentageOfOwnVolume) < (High[0] - Close[0])) { // maintain 50% of own volume				
				if(Close[0] < High[1] - (prevRange * TakeOutPercentageOfPreviousBarsVolume)){ // takes out 50% of previous bars range
					if((High[0] - Open[0]) < range * DoesntTradeMoreThanPercentageFromOpen){ // doesn't trade more than 20% of own range lower than open
						BarBrushes[0] = BearishCandleColor;
						CandleOutlineBrushes[0] = BearishOutlineColor;
					}
				}
			}
			
		}
		#region Properties

		[Range(0.01, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "MaintainPercentageOfOwnVolume", GroupName = "NinjaScriptParameters", Order = 0)]
		public double MaintainPercentageOfOwnVolume
		{ get; set; }

		[Range(0.01, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "TakeOutPercentageOfPreviousBarsVolume", GroupName = "NinjaScriptParameters", Order = 1)]
		public double TakeOutPercentageOfPreviousBarsVolume
		{ get; set; }
		
		[Range(0.01, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "DoesntTradeMoreThanPercentageFromOpen", GroupName = "NinjaScriptParameters", Order = 2)]
		public double DoesntTradeMoreThanPercentageFromOpen
		{ get; set; }
		
		[Range(0.01, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "BarMustBeAtLeastThisPercentageOfATR", GroupName = "NinjaScriptParameters", Order = 3)]
		public double BarMustBeAtLeastThisPercentageOfATR
		{ get; set; }
		
		[XmlIgnore()]
		[Display(Name = "BullishOutlineColor", GroupName = "NinjaScriptParameters", Order = 4)]
		public Brush BullishOutlineColor
		{ get; set; }
		
		[XmlIgnore()]
		[Display(Name = "BearishOutlineColor", GroupName = "NinjaScriptParameters", Order = 6)]
		public Brush BearishOutlineColor
		{ get; set; }		
				
		[XmlIgnore()]
		[Display(Name = "BullishCandleColor", GroupName = "NinjaScriptParameters", Order = 5)]
		public Brush BullishCandleColor
		{ get; set; }
		
		[XmlIgnore()]
		[Display(Name = "BearishCandleColor", GroupName = "NinjaScriptParameters", Order = 7)]
		public Brush BearishCandleColor
		{ get; set; }

		
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private BMDRotationDecisionCandle[] cacheBMDRotationDecisionCandle;
		public BMDRotationDecisionCandle BMDRotationDecisionCandle(double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			return BMDRotationDecisionCandle(Input, maintainPercentageOfOwnVolume, takeOutPercentageOfPreviousBarsVolume, doesntTradeMoreThanPercentageFromOpen, barMustBeAtLeastThisPercentageOfATR);
		}

		public BMDRotationDecisionCandle BMDRotationDecisionCandle(ISeries<double> input, double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			if (cacheBMDRotationDecisionCandle != null)
				for (int idx = 0; idx < cacheBMDRotationDecisionCandle.Length; idx++)
					if (cacheBMDRotationDecisionCandle[idx] != null && cacheBMDRotationDecisionCandle[idx].MaintainPercentageOfOwnVolume == maintainPercentageOfOwnVolume && cacheBMDRotationDecisionCandle[idx].TakeOutPercentageOfPreviousBarsVolume == takeOutPercentageOfPreviousBarsVolume && cacheBMDRotationDecisionCandle[idx].DoesntTradeMoreThanPercentageFromOpen == doesntTradeMoreThanPercentageFromOpen && cacheBMDRotationDecisionCandle[idx].BarMustBeAtLeastThisPercentageOfATR == barMustBeAtLeastThisPercentageOfATR && cacheBMDRotationDecisionCandle[idx].EqualsInput(input))
						return cacheBMDRotationDecisionCandle[idx];
			return CacheIndicator<BMDRotationDecisionCandle>(new BMDRotationDecisionCandle(){ MaintainPercentageOfOwnVolume = maintainPercentageOfOwnVolume, TakeOutPercentageOfPreviousBarsVolume = takeOutPercentageOfPreviousBarsVolume, DoesntTradeMoreThanPercentageFromOpen = doesntTradeMoreThanPercentageFromOpen, BarMustBeAtLeastThisPercentageOfATR = barMustBeAtLeastThisPercentageOfATR }, input, ref cacheBMDRotationDecisionCandle);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.BMDRotationDecisionCandle BMDRotationDecisionCandle(double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			return indicator.BMDRotationDecisionCandle(Input, maintainPercentageOfOwnVolume, takeOutPercentageOfPreviousBarsVolume, doesntTradeMoreThanPercentageFromOpen, barMustBeAtLeastThisPercentageOfATR);
		}

		public Indicators.BMDRotationDecisionCandle BMDRotationDecisionCandle(ISeries<double> input , double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			return indicator.BMDRotationDecisionCandle(input, maintainPercentageOfOwnVolume, takeOutPercentageOfPreviousBarsVolume, doesntTradeMoreThanPercentageFromOpen, barMustBeAtLeastThisPercentageOfATR);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.BMDRotationDecisionCandle BMDRotationDecisionCandle(double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			return indicator.BMDRotationDecisionCandle(Input, maintainPercentageOfOwnVolume, takeOutPercentageOfPreviousBarsVolume, doesntTradeMoreThanPercentageFromOpen, barMustBeAtLeastThisPercentageOfATR);
		}

		public Indicators.BMDRotationDecisionCandle BMDRotationDecisionCandle(ISeries<double> input , double maintainPercentageOfOwnVolume, double takeOutPercentageOfPreviousBarsVolume, double doesntTradeMoreThanPercentageFromOpen, double barMustBeAtLeastThisPercentageOfATR)
		{
			return indicator.BMDRotationDecisionCandle(input, maintainPercentageOfOwnVolume, takeOutPercentageOfPreviousBarsVolume, doesntTradeMoreThanPercentageFromOpen, barMustBeAtLeastThisPercentageOfATR);
		}
	}
}

#endregion
